@echo off
:top
cls
rem - wait for any files being added to the folder, then begin processing
@echo.
@echo.
@echo                    *Waiting For New FLV File*
@echo.
@echo.
waitdirchg
@echo.

rem - sleep for a minute to allow file copying
@echo.
@echo.
@echo                Sleeping for 30 Seconds Before Transcoding
sleep 30

rem - ensure the FLV has been completely copied to the folder before encoding to h264
for %%a in (*.flv) do waitfilecomplete "%%a" & ffmpeg -i "%%a" -vcodec h264 -flags +loop -cmp +chroma -deblockalpha 0 -deblockbeta 0 -b 5000k -bufsize 4M -bt 256k -refs 1 -bf 3 -coder 1 -me umh -me_range 16 -subq 7 -partitions +parti4x4+parti8x8+partp8x8+partb8x8 -g 250 -keyint_min 25 -level 30 -qmin 10 -qmax 51 -qcomp 0.6 -trellis 2 -sc_threshold 40 -i_qfactor 0.71 -acodec aac -ab 128k -ar 48000 -ac 2 -threads auto -y "%%~na.h264.mp4"

rem - rename the FLV files in the folder so the batch doesn't re-encode them on the next round
move /y *.avi completed_AVI
move /y *.mp4 completed_MP4

rem - loop back up and wait once again for a change in the directory
goto top