# Clever FFmpeg GUI

[![Windows](https://img.shields.io/badge/Platform-Windows-blue?style=flat-square&logo=windows)](https://www.microsoft.com/windows)
[![Portable](https://img.shields.io/badge/Type-Portable-brightgreen?style=flat-square)](https://en.wikipedia.org/wiki/Portable_application)
[![FFmpeg](https://img.shields.io/badge/Powered%20by-FFmpeg-orange?style=flat-square&logo=ffmpeg)](https://ffmpeg.org/)

## 🚀 Quick Overview

Clever FFmpeg GUI is a lightweight, powerful GUI tool for FFmpeg video and audio processing on Windows.

## 📥 Download FFmpeg

First of all, download a ffmpeg static or shared build here:

(Choose the version that matches your OS)

| Architecture | Download Link |
|-------------|---------------|
| x64 | [FFmpeg-master-latest-win64-gpl-shared.zip](https://github.com/BtbN/FFmpeg-Builds/releases/download/latest/ffmpeg-master-latest-win64-gpl-shared.zip) |
| x86 | [FFmpeg-master-latest-win32-gpl-shared.zip](https://github.com/sudo-nautilus/FFmpeg-Builds-Win32/releases/download/latest/ffmpeg-master-latest-win32-gpl-shared.zip) |

## 🔧 Installation

1. Extract files to a new folder, name it as you wish
2. Ensure the folder has full user access permissions
   [required for config file creation]
3. On first start, specify ffmpeg bin path and a target folder

## ✨ Features

### 🎬 Video Processing
- Stream Detection
- Stream Extraction
- Stream Conversion
- Automatic Crop Detection
- Fade In/Out
- Aspect Ratio Modification
- Profile Level Change

### 🔊 Audio Processing
- Stream Detection
- Volume Detection
- Length and Pitch Modification
- Channel Remapping (mono, stereo, 5.1, 7.1)
- Downmix Support

### 📀 DVD Ripping
- Supports unprotected DVDs
- Partial or Full Movie Ripping

## 🖥️ Supported Encodings

### Video Encodings
![Encoding](https://img.shields.io/badge/Video%20Formats-x264%20%7C%20x265%20%7C%20VP8%20%7C%20VP9%20%7C%20AV1-brightgreen)
- MPEG1, MPEG2
- Theora, x264 (AVC)
- x265 (HEVC)
- FFV1, Divx, Xvid
- DNxHD, DNxHR
- WMV1, WMV2, ProRes

### Audio Encodings
![Audio](https://img.shields.io/badge/Audio%20Formats-AAC%20%7C%20AC3%20%7C%20FLAC%20%7C%20MP3-blue)
- AAC, AC3, EAC3
- DTS, FLAC
- MP2, MP3
- Opus, Vorbis
- PCM, TrueHD

### Multiplex Formats
![Multiplex](https://img.shields.io/badge/Multiplex-3GP%20%7C%20MKV%20%7C%20MP4%20%7C%20WebM-orange)
- 3GP, ASF, AVI
- FLV, M2TS, MOV
- MPG, MP4, MKV
- OGG, TS, VOB
- WebM, WMV

### Subtitle Support
![Subtitles](https://img.shields.io/badge/Subtitle-ASS%20%7C%20SSA%20%7C%20SRT%20%7C%20VTT%20%7C%20VOB-orange)
- ASS, SSA
- SRT, VTT
- VOBSub

## 🔌 Additional Requirements [Recommended]
- Avisynth+ (v2.7.2)
  - Working Avisynth+ installation with the necessary plugins
- VirtualDub2 recommended for script testing
  - You need VirtualDub2 to test Avisynth+ scripts

## 🔌 Links

- [AviSynth+](https://avs-plus.net)
- [VirtualDub2](https://sourceforge.net/projects/vdfiltermod/files)

## License [Optional]

MIT License

Copyright (c) 2025 ProWo

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, distribute, and publish copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

## Author

ProWo

## Acknowledgements

Findu
